/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.client.api.standalone;

import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.sonarsource.sonarlint.core.client.api.common.analysis.ClientInputFile;

@Immutable
public class StandaloneAnalysisConfiguration {
    private final Iterable<ClientInputFile> inputFiles;
    private final Map<String, String> extraProperties;
    private final Path workDir;
    private final Path baseDir;

    public StandaloneAnalysisConfiguration(Path baseDir, Path workDir, Iterable<ClientInputFile> inputFiles, Map<String, String> extraProperties) {
        this.baseDir = baseDir;
        this.workDir = workDir;
        this.inputFiles = inputFiles;
        this.extraProperties = new LinkedHashMap<String, String>(extraProperties);
    }

    public Map<String, String> extraProperties() {
        return Collections.unmodifiableMap(this.extraProperties);
    }

    public Path baseDir() {
        return this.baseDir;
    }

    public Path workDir() {
        return this.workDir;
    }

    public Iterable<ClientInputFile> inputFiles() {
        return this.inputFiles;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[\n");
        sb.append("  baseDir: ").append(this.baseDir).append("\n");
        sb.append("  workDir: ").append(this.workDir).append("\n");
        sb.append("  extraProperties: ").append(this.extraProperties).append("\n");
        sb.append("  inputFiles: [\n");
        for (ClientInputFile inputFile : this.inputFiles) {
            sb.append("    ").append(inputFile.getPath().toString());
            if (inputFile.isTest()) {
                sb.append(" [test]");
            }
            sb.append("\n");
        }
        sb.append("  ]\n");
        sb.append("]\n");
        return sb.toString();
    }
}

